
$('#baixar').on('click',function (e) {
    e.preventDefault()
    const href = $(this).attr('href');
    let timerInterval

    Swal.fire({
        title: 'Baixando o arquivo',
        html: 'Isto terminará <b></b> segundos.',
        timer: 3000,
        timerProgressBar: true,
        didOpen: () => {
            Swal.showLoading()
            const b = Swal.getHtmlContainer().querySelector('b')
            timerInterval = setInterval(() => {
                b.textContent = Swal.getTimerLeft()
            }, 100)
        },
        willClose: () => {
            clearInterval(timerInterval)
        }
    }).then((result) => {
            if (result.dismiss === Swal.DismissReason.timer) {
                document.location.href = href;
            }
    })
});

$('#cancelar').on('click',function (e) {
    e.preventDefault()
    const href = $(this).attr('href');
    Swal.fire({
        title: 'Deseja se inscrever?',
        text: "",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sim!'
    }).then((result) => {
        if (result.isConfirmed) {
            document.location.href = href;
        }
    })
});

