<?php

namespace App\Controller;

use App\Entity\Contato;
use App\Form\ContatoType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class ContatoController extends AbstractController
{
    #[Route('/contato', name: 'app_contato')]
    public function index(EntityManagerInterface $em, Request $request): Response
    {

        $contato = new Contato();
        $form = $this->createForm(ContatoType::class, $contato);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em->persist($contato);
            $em->flush();

            return $this->redirectToRoute('app_contato');
        }
        return $this->render('contato/index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
