<?php

namespace App\Controller;

use App\Entity\Ebook;
use App\Repository\AnuncioRepository;
use App\Repository\EbookRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/ebook/download', name: 'app_ebook_download_')]
class DownloadController extends AbstractController
{
    #[Route('/{id}', name: 'index')]
    public function index(Ebook $ebook, EbookRepository $ebookRepository, EntityManagerInterface $em, AnuncioRepository $anuncioRepository, PaginatorInterface $paginator, Request $request): Response
    {
        $query2 = $anuncioRepository->findAll();
        $anuncios = $paginator->paginate($query2,$request->query->getInt('page',1),6 );
        $ebook = $ebookRepository->find($ebook);
        $ebook->addUsuario($this->getUser());
        $ebook->setQuantidadeDownload($ebook->getQuantidadeDownload()+1);
        $em->persist($ebook);
        $em->flush();
        return $this->render('download/index.html.twig', [
            'bookinfo' => $ebook,
            'anuncios' => $anuncios
        ]);
    }

}
