<?php

namespace App\Controller;

use App\Entity\Categoria;
use App\Entity\Ebook;
use App\Form\EbookType;
use App\Repository\AnuncioRepository;
use App\Repository\EbookRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/ebook')]
class EbookController extends AbstractController
{
    #[Route('/', name: 'app_ebook_index', methods: ['GET'])]
    public function index(EbookRepository $ebookRepository, AnuncioRepository $anuncioRepository, PaginatorInterface $paginator, Request $request): Response
    {
        $query2 = $anuncioRepository->findAll();
        $anuncios = $paginator->paginate($query2,$request->query->getInt('page',1),6 );
        return $this->render('ebook/index.html.twig', [
            'ebooks' => $ebookRepository->findAll(),
            'anuncios' => $anuncios
        ]);
    }
    #[Route('/categoria/{id}', name: 'app_ebook_buscar')]
    public function buscarEbooks(Categoria $categoria, EbookRepository $ebookRepository,
                                 PaginatorInterface $paginator, Request $request, AnuncioRepository $anuncioRepository): Response
    {
        $query2 = $anuncioRepository->findAll();
        $anuncios = $paginator->paginate($query2,$request->query->getInt('page',1),6 );
        $query = $ebookRepository->findByEbookPorCategoria($categoria);
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),6 );

        return $this->render('ebook/ebooks.html.twig', [
            'ebooks' => $pagination,
            'categoria' => $categoria,
            'anuncios' => $anuncios
        ]);
    }

    #[Route('/new', name: 'app_ebook_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $ebook = new Ebook();
        $form = $this->createForm(EbookType::class, $ebook);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($ebook);
            $entityManager->flush();

            return $this->redirectToRoute('app_ebook_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('ebook/new.html.twig', [
            'ebook' => $ebook,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_ebook_show', methods: ['GET'])]
    public function show(Ebook $ebook): Response
    {
        return $this->render('ebook/show.html.twig', [
            'ebook' => $ebook,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_ebook_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Ebook $ebook, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(EbookType::class, $ebook);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_ebook_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('ebook/edit.html.twig', [
            'ebook' => $ebook,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_ebook_delete', methods: ['POST'])]
    public function delete(Request $request, Ebook $ebook, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$ebook->getId(), $request->request->get('_token'))) {
            $entityManager->remove($ebook);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_ebook_index', [], Response::HTTP_SEE_OTHER);
    }
}
