<?php

namespace App\Controller;

use App\Entity\Inscricao;
use App\Form\InscricaoType;
use App\Repository\InscricaoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Dompdf\Dompdf;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Endroid\QrCode\Builder\BuilderInterface;

#[Route('/inscricao')]
class InscricaoController extends AbstractController
{
    #[Route('/', name: 'app_inscricao_index', methods: ['GET'])]
    public function index(InscricaoRepository $inscricaoRepository): Response
    {
        return $this->render('inscricao/index.html.twig', [
            'inscricaos' => $inscricaoRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'app_inscricao_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager,
                        InscricaoRepository $inscricaoRepository, BuilderInterface $qrBuilder): Response
    {


        $inscricao = new Inscricao();
        $form = $this->createForm(InscricaoType::class, $inscricao);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $random = random_int(1,3000);
            $inscricao->setCodigoInscricao("INS-".$random);
            $entityManager->persist($inscricao);
            $entityManager->flush();



            $inscrito = $inscricaoRepository->find($inscricao);

            $qrResult = $qrBuilder->
            size(400)
                ->margin(20)
                ->data('Códico de inscrição:'.$inscrito->getCodigoInscricao().' Nome:'.$inscrito->getNomeFormando())
                ->build();

            $base64Imagem = $qrResult->getDataUri();

            $imagem = $this->imageToBase64($this->getParameter('kernel.project_dir') . '/public/imagemcurso/elitebook.PNG');
            $foto = $this->imageToBase64($this->getParameter('kernel.project_dir') . '/public/imagemcurso/'.$inscrito->getFoto());
            $html =  $this->renderView('ficha_inscricao/index.html.twig',
                ['inscrito' => $inscrito,
                    'imagem' => $imagem,
                    'foto' =>$foto,
                    'qr_code' => $base64Imagem]);
            $dompdf = new Dompdf();
            $dompdf->loadHtml($html);
            $dompdf->render();

            return new Response (
                $dompdf->stream('resume', ["Attachment" => false]),
                Response::HTTP_OK,
                ['Content-Type' => 'application/pdf']
            );

            //return $this->redirectToRoute('app_ficha_inscricao', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('inscricao/new.html.twig', [
            'inscricao' => $inscricao,
            'form' => $form,
        ]);
    }

    private function imageToBase64($path) {
        $path = $path;
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        return $base64;
    }

    #[Route('/{id}', name: 'app_inscricao_show', methods: ['GET'])]
    public function show(Inscricao $inscricao): Response
    {
        return $this->render('inscricao/show.html.twig', [
            'inscricao' => $inscricao,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_inscricao_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Inscricao $inscricao, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(InscricaoType::class, $inscricao);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_inscricao_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('inscricao/edit.html.twig', [
            'inscricao' => $inscricao,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_inscricao_delete', methods: ['POST'])]
    public function delete(Request $request, Inscricao $inscricao, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$inscricao->getId(), $request->request->get('_token'))) {
            $entityManager->remove($inscricao);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_inscricao_index', [], Response::HTTP_SEE_OTHER);
    }
}
