<?php

namespace App\Controller;

use App\Repository\AnuncioRepository;
use App\Repository\CategoriaRepository;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class PrincipalController extends AbstractController
{
    #[Route('/', name: 'app_principal')]
    public function index(CategoriaRepository $categoriaRepository,PaginatorInterface $paginator, Request $request, AnuncioRepository $anuncioRepository): Response
    {
        $query2 = $anuncioRepository->findAll();
        $anuncios = $paginator->paginate($query2,$request->query->getInt('page',1),6 );
        $query = $categoriaRepository->findAll();
        $categorias = $paginator->paginate($query,$request->query->getInt('page',1),6 );

        return $this->render('principal/index.html.twig', [
            'categorias' => $categorias ,
            'anuncios' =>$anuncios
        ]);
    }
}
