<?php

namespace App\Entity;

use App\Repository\EbookRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: EbookRepository::class)]
#[Vich\Uploadable]
class Ebook
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $nome = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $descricao = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 13, scale: 2, nullable: true)]
    private ?string $preco = null;

    #[ORM\ManyToOne(inversedBy: 'ebooks')]
    private ?Categoria $categoria = null;

    // NOTE: This is not a mapped field of entity metadata, just a simple property.
    #[Vich\UploadableField(mapping: 'images', fileNameProperty: 'imagem', size: 'imageSize')]
    private ?File $imagemFile = null;

    #[ORM\Column(nullable: true)]
    private ?int $imageSize = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $imagem = null;

    #[Vich\UploadableField(mapping: 'pdfs', fileNameProperty: 'arquivo', size: 'arquivoSize')]
    private ?File $arquivoFile = null;

    #[ORM\Column(nullable: true)]
    private ?int $arquivoSize = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $arquivo = null;

    #[ORM\Column(length: 15, nullable: true)]
    private ?string $versao = null;

    #[ORM\Column(nullable: true)]
    private ?int $quantidadeDownload = null;

    #[ORM\ManyToMany(targetEntity: Usuario::class, mappedBy: 'baixouLivro')]
    private Collection $usuarios;

    public function __construct()
    {
        $this->usuarios = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(?string $nome): static
    {
        $this->nome = $nome;

        return $this;
    }

    public function getDescricao(): ?string
    {
        return $this->descricao;
    }

    public function setDescricao(?string $descricao): static
    {
        $this->descricao = $descricao;

        return $this;
    }

    public function getPreco(): ?string
    {
        return $this->preco;
    }

    public function setPreco(?string $preco): static
    {
        $this->preco = $preco;

        return $this;
    }

    public function getCategoria(): ?Categoria
    {
        return $this->categoria;
    }

    public function setCategoria(?Categoria $categoria): static
    {
        $this->categoria = $categoria;

        return $this;
    }

    public function getImagem(): ?string
    {
        return $this->imagem;
    }

    public function setImagem(?string $imagem): static
    {
        $this->imagem = $imagem;

        return $this;
    }

    public function getArquivo(): ?string
    {
        return $this->arquivo;
    }

    public function setArquivo(?string $arquivo): static
    {
        $this->arquivo = $arquivo;

        return $this;
    }


    /**
     * If manually uploading a file (i.e. not using Symfony Form) ensure an instance
     * of 'UploadedFile' is injected into this setter to trigger the update. If this
     * bundle's configuration parameter 'inject_on_load' is set to 'true' this setter
     * must be able to accept an instance of 'File' as the bundle will inject one here
     * during Doctrine hydration.
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile|null $imageFile
     */
    public function setImagemFile(?File $imagemFile = null): void
    {
        $this->imagemFile = $imagemFile;

        if (null !== $imagemFile) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }
    }

    public function getImagemFile(): ?File
    {
        return $this->imagemFile;
    }

    public function setImageSize(?int $imageSize): void
    {
        $this->imageSize = $imageSize;
    }

    public function getImageSize(): ?int
    {
        return $this->imageSize;
    }
    /**
     * If manually uploading a file (i.e. not using Symfony Form) ensure an instance
     * of 'UploadedFile' is injected into this setter to trigger the update. If this
     * bundle's configuration parameter 'inject_on_load' is set to 'true' this setter
     * must be able to accept an instance of 'File' as the bundle will inject one here
     * during Doctrine hydration.
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile|null $arquivoFile
     */
    public function setArquivoFile(?File $arquivoFile = null): void
    {
        $this->arquivoFile = $arquivoFile;

        if (null !== $arquivoFile) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }
    }

    public function getArquivoFile(): ?File
    {
        return $this->arquivoFile;
    }

    public function setArquivoSize(?int $arquivoSize): void
    {
        $this->arquivoSize = $arquivoSize;
    }

    public function getArquivoSize(): ?int
    {
        return $this->arquivoSize;
    }

    public function getVersao(): ?string
    {
        return $this->versao;
    }

    public function setVersao(?string $versao): static
    {
        $this->versao = $versao;

        return $this;
    }

    public function getQuantidadeDownload(): ?int
    {
        return $this->quantidadeDownload;
    }

    public function setQuantidadeDownload(?int $quantidadeDownload): static
    {
        $this->quantidadeDownload = $quantidadeDownload;

        return $this;
    }

    /**
     * @return Collection<int, Usuario>
     */
    public function getUsuarios(): Collection
    {
        return $this->usuarios;
    }

    public function addUsuario(Usuario $usuario): static
    {
        if (!$this->usuarios->contains($usuario)) {
            $this->usuarios->add($usuario);
            $usuario->addBaixouLivro($this);
        }

        return $this;
    }

    public function removeUsuario(Usuario $usuario): static
    {
        if ($this->usuarios->removeElement($usuario)) {
            $usuario->removeBaixouLivro($this);
        }

        return $this;
    }

}
