<?php

namespace App\Entity;

use App\Repository\InscricaoRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Vich\UploaderBundle\Mapping\Annotation as Vich;
use Symfony\Component\HttpFoundation\File\UploadedFile;

#[ORM\Entity(repositoryClass: InscricaoRepository::class)]
#[Vich\Uploadable]
class Inscricao
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 130, nullable: true)]
    private ?string $nomeFormando = null;

    #[ORM\Column(length: 30, nullable: true)]
    private ?string $numBi = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $dataInscricao = null;

    #[ORM\Column(nullable: true)]
    private ?int $telemovel = null;

    #[ORM\Column(length: 40, nullable: true)]
    private ?string $codigoInscricao = null;

    #[ORM\ManyToOne(inversedBy: 'inscricaos')]
    private ?Curso $curso = null;

    // NOTE: This is not a mapped field of entity metadata, just a simple property.
    #[Vich\UploadableField(mapping: 'images_curso', fileNameProperty: 'foto', size: 'imageSize')]
    private ?File $imagemFile = null;

    #[ORM\Column(nullable: true)]
    private ?int $imageSize = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $foto = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $endereco = null;

    #[ORM\Column(length: 20, nullable: true)]
    private ?string $sexo = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dataNascimento = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $profissao = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $email = null;



    public function __construct()
    {
       $this->dataInscricao = new \DateTimeImmutable();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNomeFormando(): ?string
    {
        return $this->nomeFormando;
    }

    public function setNomeFormando(?string $nomeFormando): static
    {
        $this->nomeFormando = $nomeFormando;

        return $this;
    }

    public function getNumBi(): ?string
    {
        return $this->numBi;
    }

    public function setNumBi(?string $numBi): static
    {
        $this->numBi = $numBi;

        return $this;
    }

    public function getDataInscricao(): ?\DateTimeImmutable
    {
        return $this->dataInscricao;
    }

    public function setDataInscricao(?\DateTimeImmutable $dataInscricao): static
    {
        $this->dataInscricao = $dataInscricao;

        return $this;
    }

    public function getTelemovel(): ?int
    {
        return $this->telemovel;
    }

    public function setTelemovel(?int $telemovel): static
    {
        $this->telemovel = $telemovel;

        return $this;
    }

    public function getCodigoInscricao(): ?string
    {
        return $this->codigoInscricao;
    }

    public function setCodigoInscricao(?string $codigoInscricao): static
    {
        $this->codigoInscricao = $codigoInscricao;

        return $this;
    }

    public function getCurso(): ?Curso
    {
        return $this->curso;
    }

    public function setCurso(?Curso $curso): static
    {
        $this->curso = $curso;

        return $this;
    }

    public function getFoto(): ?string
    {
        return $this->foto;
    }

    public function setFoto(?string $foto): static
    {
        $this->foto = $foto;

        return $this;
    }


    public function getEndereco(): ?string
    {
        return $this->endereco;
    }

    public function setEndereco(?string $endereco): static
    {
        $this->endereco = $endereco;

        return $this;
    }

    public function getSexo(): ?string
    {
        return $this->sexo;
    }

    public function setSexo(?string $sexo): static
    {
        $this->sexo = $sexo;

        return $this;
    }



    /**
     * If manually uploading a file (i.e. not using Symfony Form) ensure an instance
     * of 'UploadedFile' is injected into this setter to trigger the update. If this
     * bundle's configuration parameter 'inject_on_load' is set to 'true' this setter
     * must be able to accept an instance of 'File' as the bundle will inject one here
     * during Doctrine hydration.
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile|null $imagemFile
     */
    public function setImagemFile(?File $imagemFile = null): void
    {
        $this->imagemFile = $imagemFile;

        if (null !== $imagemFile) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }
    }

    public function getImagemFile(): ?File
    {
        return $this->imagemFile;
    }

    public function setImageSize(?int $imageSize): void
    {
        $this->imageSize = $imageSize;
    }

    public function getImageSize(): ?int
    {
        return $this->imageSize;
    }

    public function getDataNascimento(): ?\DateTimeInterface
    {
        return $this->dataNascimento;
    }

    public function setDataNascimento(?\DateTimeInterface $dataNascimento): static
    {
        $this->dataNascimento = $dataNascimento;

        return $this;
    }

    public function getProfissao(): ?string
    {
        return $this->profissao;
    }

    public function setProfissao(?string $profissao): static
    {
        $this->profissao = $profissao;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): static
    {
        $this->email = $email;

        return $this;
    }

}
