<?php

namespace App\Entity;

use App\Repository\UsuarioRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Security\Core\User\PasswordAuthenticatedUserInterface;
use Symfony\Component\Security\Core\User\UserInterface;

#[ORM\Entity(repositoryClass: UsuarioRepository::class)]
#[UniqueEntity(fields: ['email'], message: 'There is already an account with this email')]
class Usuario implements UserInterface, PasswordAuthenticatedUserInterface
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 180, unique: true)]
    private ?string $email = null;

    #[ORM\Column]
    private array $roles = [];

    /**
     * @var string The hashed password
     */
    #[ORM\Column]
    private ?string $password = null;

    #[ORM\Column(type: 'boolean')]
    private $isVerified = false;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $nome = null;

    #[ORM\Column(nullable: true)]
    private ?int $contato = null;

    #[ORM\Column(length: 45, nullable: true)]
    private ?string $areaDeestudos = null;

    #[ORM\ManyToMany(targetEntity: Ebook::class, inversedBy: 'usuarios')]
    private Collection $baixouLivro;

    public function __construct()
    {
        $this->baixouLivro = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): static
    {
        $this->email = $email;

        return $this;
    }

    /**
     * A visual identifier that represents this user.
     *
     * @see UserInterface
     */
    public function getUserIdentifier(): string
    {
        return (string) $this->email;
    }

    /**
     * @see UserInterface
     */
    public function getRoles(): array
    {
        $roles = $this->roles;
        // guarantee every user at least has ROLE_USER
        $roles[] = 'ROLE_USER';

        return array_unique($roles);
    }

    public function setRoles(array $roles): static
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * @see PasswordAuthenticatedUserInterface
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    public function setPassword(string $password): static
    {
        $this->password = $password;

        return $this;
    }

    /**
     * @see UserInterface
     */
    public function eraseCredentials(): void
    {
        // If you store any temporary, sensitive data on the user, clear it here
        // $this->plainPassword = null;
    }

    public function isVerified(): bool
    {
        return $this->isVerified;
    }

    public function setIsVerified(bool $isVerified): static
    {
        $this->isVerified = $isVerified;

        return $this;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(?string $nome): static
    {
        $this->nome = $nome;

        return $this;
    }

    public function getContato(): ?int
    {
        return $this->contato;
    }

    public function setContato(?int $contato): static
    {
        $this->contato = $contato;

        return $this;
    }

    public function getAreaDeestudos(): ?string
    {
        return $this->areaDeestudos;
    }

    public function setAreaDeestudos(?string $areaDeestudos): static
    {
        $this->areaDeestudos = $areaDeestudos;

        return $this;
    }

    /**
     * @return Collection<int, Ebook>
     */
    public function getBaixouLivro(): Collection
    {
        return $this->baixouLivro;
    }

    public function addBaixouLivro(Ebook $baixouLivro): static
    {
        if (!$this->baixouLivro->contains($baixouLivro)) {
            $this->baixouLivro->add($baixouLivro);
        }

        return $this;
    }

    public function removeBaixouLivro(Ebook $baixouLivro): static
    {
        $this->baixouLivro->removeElement($baixouLivro);

        return $this;
    }
}
