<?php

namespace App\Form;

use App\Entity\Categoria;
use App\Entity\Ebook;
use App\Repository\CategoriaRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichFileType;
use Vich\UploaderBundle\Form\Type\VichImageType;

class EbookType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nome')
            ->add('descricao')
            ->add('preco')
            ->add('imagemFile', VichImageType::class)
            ->add('categoria',EntityType::class,[
                'class'=> Categoria::class,
                'choice_label' => 'nome',
                'label' => 'Categoria',
                'query_builder' => function(CategoriaRepository $categoriaRepository){
                    return $categoriaRepository->createQueryBuilder('c')
                        ->orderBy('c.nome','ASC');
                }
            ])
            ->add('arquivoFile', VichFileType::class)
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Ebook::class,
        ]);
    }
}
