<?php

namespace App\Form;

use App\Entity\Curso;
use App\Entity\Inscricao;
use App\Repository\CursoRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichImageType;

class InscricaoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('imagemFile', VichImageType::class)
            ->add('nomeFormando',TextType::class)
            ->add('dataNascimento',DateTimeType::class,[
                'widget' => 'single_text',
            ])
            ->add('numBi',TextType::class)
            ->add('email', EmailType::class)
            ->add('profissao', TextType::class)
            ->add('endereco', TextareaType::class)
            ->add('sexo',ChoiceType::class,[
                'choices'=> array(
                    'Masculino' => 'M',
                    'Femenino' => 'F'
                )
            ])
            ->add('telemovel')
            ->add('curso',EntityType::class,[
                'class'=> Curso::class,
                'choice_label' => 'nome',
                'label' => 'Curso',
                'query_builder' => function(CursoRepository $cursoRepository){
                    return $cursoRepository->createQueryBuilder('c')
                        ->orderBy('c.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Inscricao::class,
        ]);
    }
}
